#region Namespaces
using System;
using Microsoft.AnalysisServices;
using Microsoft.AnalysisServices.Tabular;
using System.Data;
using System.Data.SqlClient;
using Microsoft.SqlServer.Dts.Runtime;
using System.Windows.Forms;
#endregion


namespace ST_aeb3e69bfdbe42e1a334f8e5ff73f279
{
	[Microsoft.SqlServer.Dts.Tasks.ScriptTask.SSISScriptTaskEntryPointAttribute]
	public partial class ScriptMain : Microsoft.SqlServer.Dts.Tasks.ScriptTask.VSTARTScriptObjectModelBase
	{
        public void Main()
		{
            int Audit_Key = Convert.ToInt32(Dts.Variables["$Package::Audit_Key"].Value);

            string Tabular_Database_Name = Convert.ToString(Dts.Variables["User::Tabular_Database_Name"].Value);
            string Tabular_Table_Name = Convert.ToString(Dts.Variables["User::Table_Name"].Value);

            //Define SQL Server connection
            string SQL_ConnStr = Convert.ToString(Dts.Variables["User::ConnStr_Configuration_Database"].Value);


            //connect to tabular model
            string Tabular_ConnStr = Convert.ToString(Dts.Variables["User::ConnStr_Tabular_Server"].Value);
            var Tabular_Server = new Server();
            
            Tabular_Server.Connect(Tabular_ConnStr);
            Database Tabular_Db = Tabular_Server.Databases[Tabular_Database_Name];
            Model Tabular_Model = Tabular_Db.Model;
            Table Tabular_Table = Tabular_Model.Tables[Tabular_Table_Name];

            foreach (var Tabular_Partition in Tabular_Table.Partitions)
            {

                using (SqlConnection conn_Config_Database = new SqlConnection(SQL_ConnStr))
                {
                    // 1. create a command object identifying the stored procedure
                    SqlCommand exec_sproc = new SqlCommand("pr_InsertTabularPartitionsExisting", conn_Config_Database);

                    // 2. set the command object so it knows to execute a stored procedure
                    exec_sproc.CommandType = System.Data.CommandType.StoredProcedure;

                    // 3. add parameter to command, which will be passed to the stored procedure
                    exec_sproc.Parameters.Add(new SqlParameter("@Audit_Key", Audit_Key));
                    exec_sproc.Parameters.Add(new SqlParameter("@Tabular_Database_Name", Tabular_Db.Name));
                    exec_sproc.Parameters.Add(new SqlParameter("@Table_Name", Tabular_Table.Name));
                    exec_sproc.Parameters.Add(new SqlParameter("@Partition_Name", Tabular_Partition.Name));
                    exec_sproc.Parameters.Add(new SqlParameter("@Partition_RefreshedTime", Convert.ToString(Tabular_Partition.RefreshedTime)));
                    exec_sproc.Parameters.Add(new SqlParameter("@Partition_State", Tabular_Partition.State));

                    // 4. execute the sproc
                    exec_sproc.Connection.Open();
                    exec_sproc.ExecuteNonQuery();
                    exec_sproc.Connection.Close();
                }

            }

            Dts.TaskResult = (int)ScriptResults.Success;
		}

        #region ScriptResults declaration
        enum ScriptResults
        {
            Success = Microsoft.SqlServer.Dts.Runtime.DTSExecResult.Success,
            Failure = Microsoft.SqlServer.Dts.Runtime.DTSExecResult.Failure
        };
        #endregion

	}
}